/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.search;

import filenet.vw.api.IVWTableDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.search.VWAdminSearchCategoryPanel;
import filenet.vw.toolkit.admin.search.VWBaseSearchOptions;
import filenet.vw.toolkit.admin.search.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.query.VWScopeChangeEvent;
import java.util.Vector;

class VWStatisticsSearchOptions
extends VWBaseSearchOptions {
    public VWStatisticsSearchOptions() {
        this.m_name = VWResource.s_statistics;
    }

    public VWScopeChangeEvent createScopeChangeEvent(Object source, VWSession session) {
        String[] names = null;
        VWScopeChangeEvent scEvent = null;
        try {
            if (VWStringUtils.compare(this.m_selectedScope, this.m_workflowRostersItem) == 0) {
                names = this.m_rosterNames;
            } else if (VWStringUtils.compare(this.m_selectedScope, this.m_queuesItem) == 0) {
                names = this.m_queueNames;
            }
            scEvent = new VWScopeChangeEvent(source);
            scEvent.setType(4);
            scEvent.setRespositoryNames(names);
            boolean bCurrentTime = ((VWAdminSearchCategoryPanel)source).getIsCurrentTime();
            scEvent.setAvailableColumns(this.buildSelectiveColumns(bCurrentTime));
            scEvent.setDefaultColumns(this.buildSelectiveColumns(bCurrentTime));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return scEvent;
    }

    public int getResultType() {
        return 4;
    }

    public void setScope(String nItemName) {
        this.m_nVisibleTabs = 8;
        if (VWStringUtils.compare(nItemName, this.m_workflowRostersItem) == 0) {
            this.m_nVisibleTabs |= 0x10;
            this.m_selectedScope = nItemName;
        } else if (VWStringUtils.compare(nItemName, this.m_queuesItem) == 0) {
            this.m_nVisibleTabs |= 0x20;
            this.m_selectedScope = nItemName;
        }
    }

    public String[] getScopeOptions() {
        String[] items = null;
        try {
            items = new String[]{this.m_workflowRostersItem, this.m_queuesItem};
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return items;
    }

    public String[] getSpecificScopeOptions() {
        return null;
    }

    protected String[] getDefaultColumns(IVWTableDefinition definition) {
        boolean bCurrentTime = false;
        return this.buildSelectiveColumns(bCurrentTime);
    }

    private String[] buildAllColumns() {
        Vector<String> columnNames = null;
        Object[] names = null;
        try {
            columnNames = new Vector<String>();
            columnNames.addElement(VWResource.s_numberOfSamples);
            columnNames.addElement(VWResource.s_numberOfUnitsInPeriod);
            columnNames.addElement(VWResource.s_requestedEndTime);
            columnNames.addElement(VWResource.s_requestedStartTime);
            columnNames.addElement(VWResource.s_requestedTimeUnit);
            columnNames.addElement(VWResource.s_startTime);
            if (VWStringUtils.compare(this.m_selectedScope, this.m_workflowRostersItem) == 0) {
                columnNames.addElement(VWResource.s_averageLifeSpanChildWO);
                columnNames.addElement(VWResource.s_averageLifeSpanOfWO);
                columnNames.addElement(VWResource.s_averageLifeSpanParentWO);
                columnNames.addElement(VWResource.s_averageNumberOfActiveChildWO);
                columnNames.addElement(VWResource.s_averageNumberOfActiveParentWO);
                columnNames.addElement(VWResource.s_averageNumberOfActiveWO);
                columnNames.addElement(VWResource.s_childCreationRate);
                columnNames.addElement(VWResource.s_childrenGrowRate);
                columnNames.addElement(VWResource.s_childTerminationRate);
                columnNames.addElement(VWResource.s_endTime);
                columnNames.addElement(VWResource.s_evaluationTime);
                columnNames.addElement(VWResource.s_initialNumberOfWO);
                columnNames.addElement(VWResource.s_numberOfActiveChildWO);
                columnNames.addElement(VWResource.s_numberOfActiveParentWO);
                columnNames.addElement(VWResource.s_numberOfCreatedChildWO);
                columnNames.addElement(VWResource.s_numberOfCreatedParentWO);
                columnNames.addElement(VWResource.s_numberOfInitialChildWO);
                columnNames.addElement(VWResource.s_numberOfInitialParentWO);
                columnNames.addElement(VWResource.s_numberOfRemainingChildWO);
                columnNames.addElement(VWResource.s_numberOfRemainingParentWO);
                columnNames.addElement(VWResource.s_numberOfTerminatedChildWO);
                columnNames.addElement(VWResource.s_numberOfTerminatedParentWO);
                columnNames.addElement(VWResource.s_parentCreationRate);
                columnNames.addElement(VWResource.s_parentGrowRate);
                columnNames.addElement(VWResource.s_parentTerminationRate);
                columnNames.addElement(VWResource.s_summationActiveChild);
                columnNames.addElement(VWResource.s_summationActiveParent);
                columnNames.addElement(VWResource.s_summationActiveWO);
                columnNames.addElement(VWResource.s_summationChildLifeSpan);
                columnNames.addElement(VWResource.s_summationParentLifeSpan);
                columnNames.addElement(VWResource.s_summationWOLifeSpan);
                columnNames.addElement(VWResource.s_totalCreationRate);
                columnNames.addElement(VWResource.s_totalGrowRate);
                columnNames.addElement(VWResource.s_totalNumberOfActiveWO);
                columnNames.addElement(VWResource.s_totalNumberOfCreatedWO);
                columnNames.addElement(VWResource.s_totalNumberOfRemainingWO);
                columnNames.addElement(VWResource.s_totalNumberOfTerminatedWO);
                columnNames.addElement(VWResource.s_totalTerminationRate);
            } else if (VWStringUtils.compare(this.m_selectedScope, this.m_queuesItem) == 0) {
                columnNames.addElement(VWResource.s_averageProcessedWO);
                columnNames.addElement(VWResource.s_averageQueueDelay);
                columnNames.addElement(VWResource.s_averageQueueDepth);
                columnNames.addElement(VWResource.s_averageThroughput);
                columnNames.addElement(VWResource.s_averageWOLocked);
                columnNames.addElement(VWResource.s_averageWOProcessingTime);
                columnNames.addElement(VWResource.s_currentQueueDepth);
                columnNames.addElement(VWResource.s_currentWOLocked);
                columnNames.addElement(VWResource.s_dequeuedRate);
                columnNames.addElement(VWResource.s_endTime);
                columnNames.addElement(VWResource.s_evaluationTime);
                columnNames.addElement(VWResource.s_initialNumberOfQueued);
                columnNames.addElement(VWResource.s_numberOfRemainingQueued);
                columnNames.addElement(VWResource.s_numberOfWOLocked);
                columnNames.addElement(VWResource.s_numberOfWOProcessed);
                columnNames.addElement(VWResource.s_queuedRate);
                columnNames.addElement(VWResource.s_queueGrowthRate);
                columnNames.addElement(VWResource.s_summationDurationWOInQueue);
                columnNames.addElement(VWResource.s_summationQueueDepth);
                columnNames.addElement(VWResource.s_summationWOLocked);
                columnNames.addElement(VWResource.s_summationWOProcessed);
                columnNames.addElement(VWResource.s_totalAbortedTime);
                columnNames.addElement(VWResource.s_totalServiceTime);
                columnNames.addElement(VWResource.s_totalWOAborted);
                columnNames.addElement(VWResource.s_totalWODequeued);
                columnNames.addElement(VWResource.s_totalWOQueued);
            }
            names = new String[columnNames.size()];
            columnNames.copyInto(names);
            return names;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private String[] buildSelectiveColumns(boolean currentTime) {
        Vector<String> columnNames = null;
        Object[] names = null;
        try {
            columnNames = new Vector<String>();
            if (currentTime) {
                if (VWStringUtils.compare(this.m_selectedScope, this.m_workflowRostersItem) == 0) {
                    columnNames.addElement(VWResource.s_evaluationTime);
                    columnNames.addElement(VWResource.s_totalNumberOfActiveWO);
                    columnNames.addElement(VWResource.s_numberOfActiveChildWO);
                    columnNames.addElement(VWResource.s_numberOfActiveParentWO);
                } else {
                    columnNames.addElement(VWResource.s_evaluationTime);
                    columnNames.addElement(VWResource.s_currentQueueDepth);
                    columnNames.addElement(VWResource.s_currentWOLocked);
                }
                names = new String[columnNames.size()];
                columnNames.copyInto(names);
            } else {
                names = this.buildAllColumns();
            }
            return names;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

